<?php
/**
 * The Classic template to display the content
 *
 * Used for index/archive/search.
 *
 * @package GAT
 * @since GAT 1.0
 */

$gat_template_args = get_query_var( 'gat_template_args' );

if ( is_array( $gat_template_args ) ) {
	$gat_columns    = empty( $gat_template_args['columns'] ) ? 2 : max( 1, $gat_template_args['columns'] );
	$gat_blog_style = array( $gat_template_args['type'], $gat_columns );
    $gat_columns_class = gat_get_column_class( 1, $gat_columns, ! empty( $gat_template_args['columns_tablet']) ? $gat_template_args['columns_tablet'] : '', ! empty($gat_template_args['columns_mobile']) ? $gat_template_args['columns_mobile'] : '' );
} else {
	$gat_template_args = array();
	$gat_blog_style = explode( '_', gat_get_theme_option( 'blog_style' ) );
	$gat_columns    = empty( $gat_blog_style[1] ) ? 2 : max( 1, $gat_blog_style[1] );
    $gat_columns_class = gat_get_column_class( 1, $gat_columns );
}
$gat_expanded   = ! gat_sidebar_present() && gat_get_theme_option( 'expand_content' ) == 'expand';

$gat_post_format = get_post_format();
$gat_post_format = empty( $gat_post_format ) ? 'standard' : str_replace( 'post-format-', '', $gat_post_format );

?><div class="<?php
	if ( ! empty( $gat_template_args['slider'] ) ) {
		echo ' slider-slide swiper-slide';
	} else {
		echo ( gat_is_blog_style_use_masonry( $gat_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $gat_columns ) : esc_attr( $gat_columns_class ) );
	}
?>"><article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $gat_post_format )
				. ' post_layout_classic post_layout_classic_' . esc_attr( $gat_columns )
				. ' post_layout_' . esc_attr( $gat_blog_style[0] )
				. ' post_layout_' . esc_attr( $gat_blog_style[0] ) . '_' . esc_attr( $gat_columns )
	);
	gat_add_blog_animation( $gat_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$gat_hover      = ! empty( $gat_template_args['hover'] ) && ! gat_is_inherit( $gat_template_args['hover'] )
							? $gat_template_args['hover']
							: gat_get_theme_option( 'image_hover' );

	$gat_components = ! empty( $gat_template_args['meta_parts'] )
							? ( is_array( $gat_template_args['meta_parts'] )
								? $gat_template_args['meta_parts']
								: explode( ',', $gat_template_args['meta_parts'] )
								)
							: gat_array_get_keys_by_value( gat_get_theme_option( 'meta_parts' ) );

	gat_show_post_featured( apply_filters( 'gat_filter_args_featured',
		array(
			'thumb_size' => ! empty( $gat_template_args['thumb_size'] )
				? $gat_template_args['thumb_size']
				: gat_get_thumb_size(
					'classic' == $gat_blog_style[0]
						? ( strpos( gat_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $gat_columns > 2 ? 'big' : 'huge' )
								: ( $gat_columns > 2
									? ( $gat_expanded ? 'square' : 'square' )
									: ($gat_columns > 1 ? 'square' : ( $gat_expanded ? 'huge' : 'big' ))
									)
							)
						: ( strpos( gat_get_theme_option( 'body_style' ), 'full' ) !== false
								? ( $gat_columns > 2 ? 'masonry-big' : 'full' )
								: ($gat_columns === 1 ? ( $gat_expanded ? 'huge' : 'big' ) : ( $gat_columns <= 2 && $gat_expanded ? 'masonry-big' : 'masonry' ))
							)
			),
			'hover'      => $gat_hover,
			'meta_parts' => $gat_components,
			'no_links'   => ! empty( $gat_template_args['no_links'] ),
        ),
        'content-classic',
        $gat_template_args
    ) );

	// Title and post meta
	$gat_show_title = get_the_title() != '';
	$gat_show_meta  = count( $gat_components ) > 0 && ! in_array( $gat_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $gat_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php

			// Post meta
			if ( apply_filters( 'gat_filter_show_blog_meta', $gat_show_meta, $gat_components, 'classic' ) ) {
				if ( count( $gat_components ) > 0 ) {
					do_action( 'gat_action_before_post_meta' );
					gat_show_post_meta(
						apply_filters(
							'gat_filter_post_meta_args', array(
							'components' => join( ',', $gat_components ),
							'seo'        => false,
							'echo'       => true,
						), $gat_blog_style[0], $gat_columns
						)
					);
					do_action( 'gat_action_after_post_meta' );
				}
			}

			// Post title
			if ( apply_filters( 'gat_filter_show_blog_title', true, 'classic' ) ) {
				do_action( 'gat_action_before_post_title' );
				if ( empty( $gat_template_args['no_links'] ) ) {
					the_title( sprintf( '<h4 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h4>' );
				} else {
					the_title( '<h4 class="post_title entry-title">', '</h4>' );
				}
				do_action( 'gat_action_after_post_title' );
			}

			if( !in_array( $gat_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
				// More button
				if ( apply_filters( 'gat_filter_show_blog_readmore', ! $gat_show_title || ! empty( $gat_template_args['more_button'] ), 'classic' ) ) {
					if ( empty( $gat_template_args['no_links'] ) ) {
						do_action( 'gat_action_before_post_readmore' );
						gat_show_post_more_link( $gat_template_args, '<div class="more-wrap">', '</div>' );
						do_action( 'gat_action_after_post_readmore' );
					}
				}
			}
			?>
		</div><!-- .entry-header -->
		<?php
	}

	// Post content
	if( in_array( $gat_post_format, array( 'quote', 'aside', 'link', 'status' ) ) ) {
		ob_start();
		if (apply_filters('gat_filter_show_blog_excerpt', empty($gat_template_args['hide_excerpt']) && gat_get_theme_option('excerpt_length') > 0, 'classic')) {
			gat_show_post_content($gat_template_args, '<div class="post_content_inner">', '</div>');
		}
		// More button
		if(! empty( $gat_template_args['more_button'] )) {
			if ( empty( $gat_template_args['no_links'] ) ) {
				do_action( 'gat_action_before_post_readmore' );
				gat_show_post_more_link( $gat_template_args, '<div class="more-wrap">', '</div>' );
				do_action( 'gat_action_after_post_readmore' );
			}
		}
		$gat_content = ob_get_contents();
		ob_end_clean();
		gat_show_layout($gat_content, '<div class="post_content entry-content">', '</div><!-- .entry-content -->');
	}
	?>

</article></div><?php
// Need opening PHP-tag above, because <div> is a inline-block element (used as column)!
