<?php
/**
 * The template to display the logo or the site name and the slogan in the Header
 *
 * @package GAT
 * @since GAT 1.0
 */

$gat_args = get_query_var( 'gat_logo_args' );

// Site logo
$gat_logo_type   = isset( $gat_args['type'] ) ? $gat_args['type'] : '';
$gat_logo_image  = gat_get_logo_image( $gat_logo_type );
$gat_logo_text   = gat_is_on( gat_get_theme_option( 'logo_text' ) ) ? get_bloginfo( 'name' ) : '';
$gat_logo_slogan = get_bloginfo( 'description', 'display' );
if ( ! empty( $gat_logo_image['logo'] ) || ! empty( $gat_logo_text ) ) {
	?><a class="sc_layouts_logo" href="<?php echo esc_url( home_url( '/' ) ); ?>">
		<?php
		if ( ! empty( $gat_logo_image['logo'] ) ) {
			if ( empty( $gat_logo_type ) && function_exists( 'the_custom_logo' ) && is_numeric($gat_logo_image['logo']) && (int) $gat_logo_image['logo'] > 0 ) {
				the_custom_logo();
			} else {
				$gat_attr = gat_getimagesize( $gat_logo_image['logo'] );
				echo '<img src="' . esc_url( $gat_logo_image['logo'] ) . '"'
						. ( ! empty( $gat_logo_image['logo_retina'] ) ? ' srcset="' . esc_url( $gat_logo_image['logo_retina'] ) . ' 2x"' : '' )
						. ' alt="' . esc_attr( $gat_logo_text ) . '"'
						. ( ! empty( $gat_attr[3] ) ? ' ' . wp_kses_data( $gat_attr[3] ) : '' )
						. '>';
			}
		} else {
			gat_show_layout( gat_prepare_macros( $gat_logo_text ), '<span class="logo_text">', '</span>' );
			gat_show_layout( gat_prepare_macros( $gat_logo_slogan ), '<span class="logo_slogan">', '</span>' );
		}
		?>
	</a>
	<?php
}
