<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package GAT
 * @since GAT 1.0.10
 */

// Footer sidebar
$gat_footer_name    = gat_get_theme_option( 'footer_widgets' );
$gat_footer_present = ! gat_is_off( $gat_footer_name ) && is_active_sidebar( $gat_footer_name );
if ( $gat_footer_present ) {
	gat_storage_set( 'current_sidebar', 'footer' );
	$gat_footer_wide = gat_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $gat_footer_name ) ) {
		dynamic_sidebar( $gat_footer_name );
	}
	$gat_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $gat_out ) ) {
		$gat_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $gat_out );
		$gat_need_columns = true;   //or check: strpos($gat_out, 'columns_wrap')===false;
		if ( $gat_need_columns ) {
			$gat_columns = max( 0, (int) gat_get_theme_option( 'footer_columns' ) );			
			if ( 0 == $gat_columns ) {
				$gat_columns = min( 4, max( 1, gat_tags_count( $gat_out, 'aside' ) ) );
			}
			if ( $gat_columns > 1 ) {
				$gat_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $gat_columns ) . ' widget', $gat_out );
			} else {
				$gat_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $gat_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<?php do_action( 'gat_action_before_sidebar_wrap', 'footer' ); ?>
			<div class="footer_widgets_inner widget_area_inner">
				<?php
				if ( ! $gat_footer_wide ) {
					?>
					<div class="content_wrap">
					<?php
				}
				if ( $gat_need_columns ) {
					?>
					<div class="columns_wrap">
					<?php
				}
				do_action( 'gat_action_before_sidebar', 'footer' );
				gat_show_layout( $gat_out );
				do_action( 'gat_action_after_sidebar', 'footer' );
				if ( $gat_need_columns ) {
					?>
					</div><!-- /.columns_wrap -->
					<?php
				}
				if ( ! $gat_footer_wide ) {
					?>
					</div><!-- /.content_wrap -->
					<?php
				}
				?>
			</div><!-- /.footer_widgets_inner -->
			<?php do_action( 'gat_action_after_sidebar_wrap', 'footer' ); ?>
		</div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
