<?php
/**
 * The template to display default site footer
 *
 * @package GAT
 * @since GAT 1.0.10
 */

$gat_footer_id = gat_get_custom_footer_id();
$gat_footer_meta = get_post_meta( $gat_footer_id, 'trx_addons_options', true );
if ( ! empty( $gat_footer_meta['margin'] ) ) {
	gat_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( gat_prepare_css_value( $gat_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_<?php echo esc_attr( $gat_footer_id ); ?> footer_custom_<?php echo esc_attr( sanitize_title( get_the_title( $gat_footer_id ) ) ); ?>
						<?php
						$gat_footer_scheme = gat_get_theme_option( 'footer_scheme' );
						if ( ! empty( $gat_footer_scheme ) && ! gat_is_inherit( $gat_footer_scheme  ) ) {
							echo ' scheme_' . esc_attr( $gat_footer_scheme );
						}
						?>
						">
	<?php
	// Custom footer's layout
	do_action( 'gat_action_show_layout', $gat_footer_id );
	?>
</footer><!-- /.footer_wrap -->
