<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package GAT
 * @since GAT 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
$gat_copyright_scheme = gat_get_theme_option( 'copyright_scheme' );
if ( ! empty( $gat_copyright_scheme ) && ! gat_is_inherit( $gat_copyright_scheme  ) ) {
	echo ' scheme_' . esc_attr( $gat_copyright_scheme );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$gat_copyright = gat_get_theme_option( 'copyright' );
			if ( ! empty( $gat_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$gat_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $gat_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$gat_copyright = gat_prepare_macros( $gat_copyright );
				// Display copyright
				echo wp_kses( nl2br( $gat_copyright ), 'gat_kses_content' );
			}
			?>
			</div>
		</div>
	</div>
</div>
