<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package GAT
 * @since GAT 1.0
 */

$gat_template_args = get_query_var( 'gat_template_args' );
$gat_columns = 1;
if ( is_array( $gat_template_args ) ) {
	$gat_columns    = empty( $gat_template_args['columns'] ) ? 1 : max( 1, $gat_template_args['columns'] );
	$gat_blog_style = array( $gat_template_args['type'], $gat_columns );
	if ( ! empty( $gat_template_args['slider'] ) ) {
		?><div class="slider-slide swiper-slide">
		<?php
	} elseif ( $gat_columns > 1 ) {
	    $gat_columns_class = gat_get_column_class( 1, $gat_columns, ! empty( $gat_template_args['columns_tablet']) ? $gat_template_args['columns_tablet'] : '', ! empty($gat_template_args['columns_mobile']) ? $gat_template_args['columns_mobile'] : '' );
		?>
		<div class="<?php echo esc_attr( $gat_columns_class ); ?>">
		<?php
	}
} else {
	$gat_template_args = array();
}
$gat_expanded    = ! gat_sidebar_present() && gat_get_theme_option( 'expand_content' ) == 'expand';
$gat_post_format = get_post_format();
$gat_post_format = empty( $gat_post_format ) ? 'standard' : str_replace( 'post-format-', '', $gat_post_format );
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class( 'post_item post_item_container post_layout_excerpt post_format_' . esc_attr( $gat_post_format ) );
	gat_add_blog_animation( $gat_template_args );
	?>
>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	// Featured image
	$gat_hover      = ! empty( $gat_template_args['hover'] ) && ! gat_is_inherit( $gat_template_args['hover'] )
							? $gat_template_args['hover']
							: gat_get_theme_option( 'image_hover' );
	$gat_components = ! empty( $gat_template_args['meta_parts'] )
							? ( is_array( $gat_template_args['meta_parts'] )
								? $gat_template_args['meta_parts']
								: array_map( 'trim', explode( ',', $gat_template_args['meta_parts'] ) )
								)
							: gat_array_get_keys_by_value( gat_get_theme_option( 'meta_parts' ) );
	gat_show_post_featured( apply_filters( 'gat_filter_args_featured',
		array(
			'no_links'   => ! empty( $gat_template_args['no_links'] ),
			'hover'      => $gat_hover,
			'meta_parts' => $gat_components,
			'thumb_size' => ! empty( $gat_template_args['thumb_size'] )
							? $gat_template_args['thumb_size']
							: gat_get_thumb_size( strpos( gat_get_theme_option( 'body_style' ), 'full' ) !== false
								? 'full'
								: ( $gat_expanded 
									? 'huge' 
									: 'big' 
									)
								),
		),
		'content-excerpt',
		$gat_template_args
	) );

	// Title and post meta
	$gat_show_title = get_the_title() != '';
	$gat_show_meta  = count( $gat_components ) > 0 && ! in_array( $gat_hover, array( 'border', 'pull', 'slide', 'fade', 'info' ) );

	if ( $gat_show_title ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post title
			if ( apply_filters( 'gat_filter_show_blog_title', true, 'excerpt' ) ) {
				do_action( 'gat_action_before_post_title' );
				if ( empty( $gat_template_args['no_links'] ) ) {
					the_title( sprintf( '<h3 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h3>' );
				} else {
					the_title( '<h3 class="post_title entry-title">', '</h3>' );
				}
				do_action( 'gat_action_after_post_title' );
			}
			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	if ( apply_filters( 'gat_filter_show_blog_excerpt', empty( $gat_template_args['hide_excerpt'] ) && gat_get_theme_option( 'excerpt_length' ) > 0, 'excerpt' ) ) {
		?>
		<div class="post_content entry-content">
			<?php

			// Post meta
			if ( apply_filters( 'gat_filter_show_blog_meta', $gat_show_meta, $gat_components, 'excerpt' ) ) {
				if ( count( $gat_components ) > 0 ) {
					do_action( 'gat_action_before_post_meta' );
					gat_show_post_meta(
						apply_filters(
							'gat_filter_post_meta_args', array(
								'components' => join( ',', $gat_components ),
								'seo'        => false,
								'echo'       => true,
							), 'excerpt', 1
						)
					);
					do_action( 'gat_action_after_post_meta' );
				}
			}

			if ( gat_get_theme_option( 'blog_content' ) == 'fullpost' ) {
				// Post content area
				?>
				<div class="post_content_inner">
					<?php
					do_action( 'gat_action_before_full_post_content' );
					the_content( '' );
					do_action( 'gat_action_after_full_post_content' );
					?>
				</div>
				<?php
				// Inner pages
				wp_link_pages(
					array(
						'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'gat' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'gat' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					)
				);
			} else {
				// Post content area
				gat_show_post_content( $gat_template_args, '<div class="post_content_inner">', '</div>' );
			}

			// More button
			if ( apply_filters( 'gat_filter_show_blog_readmore',  ! isset( $gat_template_args['more_button'] ) || ! empty( $gat_template_args['more_button'] ), 'excerpt' ) ) {
				if ( empty( $gat_template_args['no_links'] ) ) {
					do_action( 'gat_action_before_post_readmore' );
					if ( gat_get_theme_option( 'blog_content' ) != 'fullpost' ) {
						gat_show_post_more_link( $gat_template_args, '<p>', '</p>' );
					} else {
						gat_show_post_comments_link( $gat_template_args, '<p>', '</p>' );
					}
					do_action( 'gat_action_after_post_readmore' );
				}
			}

			?>
		</div><!-- .entry-content -->
		<?php
	}
	?>
</article>
<?php

if ( is_array( $gat_template_args ) ) {
	if ( ! empty( $gat_template_args['slider'] ) || $gat_columns > 1 ) {
		?>
		</div>
		<?php
	}
}
