<?php
/**
 * The custom template to display the content
 *
 * Used for index/archive/search.
 *
 * @package GAT
 * @since GAT 1.0.50
 */

$gat_template_args = get_query_var( 'gat_template_args' );
if ( is_array( $gat_template_args ) ) {
	$gat_columns    = empty( $gat_template_args['columns'] ) ? 2 : max( 1, $gat_template_args['columns'] );
	$gat_blog_style = array( $gat_template_args['type'], $gat_columns );
} else {
	$gat_template_args = array();
	$gat_blog_style = explode( '_', gat_get_theme_option( 'blog_style' ) );
	$gat_columns    = empty( $gat_blog_style[1] ) ? 2 : max( 1, $gat_blog_style[1] );
}
$gat_blog_id       = gat_get_custom_blog_id( join( '_', $gat_blog_style ) );
$gat_blog_style[0] = str_replace( 'blog-custom-', '', $gat_blog_style[0] );
$gat_expanded      = ! gat_sidebar_present() && gat_get_theme_option( 'expand_content' ) == 'expand';
$gat_components    = ! empty( $gat_template_args['meta_parts'] )
							? ( is_array( $gat_template_args['meta_parts'] )
								? join( ',', $gat_template_args['meta_parts'] )
								: $gat_template_args['meta_parts']
								)
							: gat_array_get_keys_by_value( gat_get_theme_option( 'meta_parts' ) );
$gat_post_format   = get_post_format();
$gat_post_format   = empty( $gat_post_format ) ? 'standard' : str_replace( 'post-format-', '', $gat_post_format );

$gat_blog_meta     = gat_get_custom_layout_meta( $gat_blog_id );
$gat_custom_style  = ! empty( $gat_blog_meta['scripts_required'] ) ? $gat_blog_meta['scripts_required'] : 'none';

if ( ! empty( $gat_template_args['slider'] ) || $gat_columns > 1 || ! gat_is_off( $gat_custom_style ) ) {
	?><div class="
		<?php
		if ( ! empty( $gat_template_args['slider'] ) ) {
			echo 'slider-slide swiper-slide';
		} else {
			echo esc_attr( ( gat_is_off( $gat_custom_style ) ? 'column' : sprintf( '%1$s_item %1$s_item', $gat_custom_style ) ) . "-1_{$gat_columns}" );
		}
		?>
	">
	<?php
}
?>
<article id="post-<?php the_ID(); ?>" data-post-id="<?php the_ID(); ?>"
	<?php
	post_class(
			'post_item post_item_container post_format_' . esc_attr( $gat_post_format )
					. ' post_layout_custom post_layout_custom_' . esc_attr( $gat_columns )
					. ' post_layout_' . esc_attr( $gat_blog_style[0] )
					. ' post_layout_' . esc_attr( $gat_blog_style[0] ) . '_' . esc_attr( $gat_columns )
					. ( ! gat_is_off( $gat_custom_style )
						? ' post_layout_' . esc_attr( $gat_custom_style )
							. ' post_layout_' . esc_attr( $gat_custom_style ) . '_' . esc_attr( $gat_columns )
						: ''
						)
		);
	gat_add_blog_animation( $gat_template_args );
	?>
>
	<?php
	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}
	// Custom layout
	do_action( 'gat_action_show_layout', $gat_blog_id, get_the_ID() );
	?>
</article><?php
if ( ! empty( $gat_template_args['slider'] ) || $gat_columns > 1 || ! gat_is_off( $gat_custom_style ) ) {
	?></div><?php
	// Need opening PHP-tag above just after </div>, because <div> is a inline-block element (used as column)!
}
