<?php
/**
 * The Sidebar containing the main widget areas.
 *
 * @package GAT
 * @since GAT 1.0
 */

if ( gat_sidebar_present() ) {
	
	$gat_sidebar_type = gat_get_theme_option( 'sidebar_type' );
	if ( 'custom' == $gat_sidebar_type && ! gat_is_layouts_available() ) {
		$gat_sidebar_type = 'default';
	}
	
	// Catch output to the buffer
	ob_start();
	if ( 'default' == $gat_sidebar_type ) {
		// Default sidebar with widgets
		$gat_sidebar_name = gat_get_theme_option( 'sidebar_widgets' );
		gat_storage_set( 'current_sidebar', 'sidebar' );
		if ( is_active_sidebar( $gat_sidebar_name ) ) {
			dynamic_sidebar( $gat_sidebar_name );
		}
	} else {
		// Custom sidebar from Layouts Builder
		$gat_sidebar_id = gat_get_custom_sidebar_id();
		do_action( 'gat_action_show_layout', $gat_sidebar_id );
	}
	$gat_out = trim( ob_get_contents() );
	ob_end_clean();
	
	// If any html is present - display it
	if ( ! empty( $gat_out ) ) {
		$gat_sidebar_position    = gat_get_theme_option( 'sidebar_position' );
		$gat_sidebar_position_ss = gat_get_theme_option( 'sidebar_position_ss' );
		?>
		<div class="sidebar widget_area
			<?php
			echo ' ' . esc_attr( $gat_sidebar_position );
			echo ' sidebar_' . esc_attr( $gat_sidebar_position_ss );
			echo ' sidebar_' . esc_attr( $gat_sidebar_type );

			$gat_sidebar_scheme = apply_filters( 'gat_filter_sidebar_scheme', gat_get_theme_option( 'sidebar_scheme' ) );
			if ( ! empty( $gat_sidebar_scheme ) && ! gat_is_inherit( $gat_sidebar_scheme ) && 'custom' != $gat_sidebar_type ) {
				echo ' scheme_' . esc_attr( $gat_sidebar_scheme );
			}
			?>
		" role="complementary">
			<?php

			// Skip link anchor to fast access to the sidebar from keyboard
			?>
			<a id="sidebar_skip_link_anchor" class="gat_skip_link_anchor" href="#"></a>
			<?php

			do_action( 'gat_action_before_sidebar_wrap', 'sidebar' );

			// Button to show/hide sidebar on mobile
			if ( in_array( $gat_sidebar_position_ss, array( 'above', 'float' ) ) ) {
				$gat_title = apply_filters( 'gat_filter_sidebar_control_title', 'float' == $gat_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'gat' ) : '' );
				$gat_text  = apply_filters( 'gat_filter_sidebar_control_text', 'above' == $gat_sidebar_position_ss ? esc_html__( 'Show Sidebar', 'gat' ) : '' );
				?>
				<a href="#" class="sidebar_control" title="<?php echo esc_attr( $gat_title ); ?>"><?php echo esc_html( $gat_text ); ?></a>
				<?php
			}
			?>
			<div class="sidebar_inner">
				<?php
				do_action( 'gat_action_before_sidebar', 'sidebar' );
				gat_show_layout( preg_replace( "/<\/aside>[\r\n\s]*<aside/", '</aside><aside', $gat_out ) );
				do_action( 'gat_action_after_sidebar', 'sidebar' );
				?>
			</div>
			<?php

			do_action( 'gat_action_after_sidebar_wrap', 'sidebar' );

			?>
		</div>
		<div class="clearfix"></div>
		<?php
	}
}
