<div class="front_page_section front_page_section_about<?php
	$gat_scheme = gat_get_theme_option( 'front_page_about_scheme' );
	if ( ! empty( $gat_scheme ) && ! gat_is_inherit( $gat_scheme ) ) {
		echo ' scheme_' . esc_attr( $gat_scheme );
	}
	echo ' front_page_section_paddings_' . esc_attr( gat_get_theme_option( 'front_page_about_paddings' ) );
	if ( gat_get_theme_option( 'front_page_about_stack' ) ) {
		echo ' sc_stack_section_on';
	}
?>"
		<?php
		$gat_css      = '';
		$gat_bg_image = gat_get_theme_option( 'front_page_about_bg_image' );
		if ( ! empty( $gat_bg_image ) ) {
			$gat_css .= 'background-image: url(' . esc_url( gat_get_attachment_url( $gat_bg_image ) ) . ');';
		}
		if ( ! empty( $gat_css ) ) {
			echo ' style="' . esc_attr( $gat_css ) . '"';
		}
		?>
>
<?php
	// Add anchor
	$gat_anchor_icon = gat_get_theme_option( 'front_page_about_anchor_icon' );
	$gat_anchor_text = gat_get_theme_option( 'front_page_about_anchor_text' );
if ( ( ! empty( $gat_anchor_icon ) || ! empty( $gat_anchor_text ) ) && shortcode_exists( 'trx_sc_anchor' ) ) {
	echo do_shortcode(
		'[trx_sc_anchor id="front_page_section_about"'
									. ( ! empty( $gat_anchor_icon ) ? ' icon="' . esc_attr( $gat_anchor_icon ) . '"' : '' )
									. ( ! empty( $gat_anchor_text ) ? ' title="' . esc_attr( $gat_anchor_text ) . '"' : '' )
									. ']'
	);
}
?>
	<div class="front_page_section_inner front_page_section_about_inner
	<?php
	if ( gat_get_theme_option( 'front_page_about_fullheight' ) ) {
		echo ' gat-full-height sc_layouts_flex sc_layouts_columns_middle';
	}
	?>
			"
			<?php
			$gat_css           = '';
			$gat_bg_mask       = gat_get_theme_option( 'front_page_about_bg_mask' );
			$gat_bg_color_type = gat_get_theme_option( 'front_page_about_bg_color_type' );
			if ( 'custom' == $gat_bg_color_type ) {
				$gat_bg_color = gat_get_theme_option( 'front_page_about_bg_color' );
			} elseif ( 'scheme_bg_color' == $gat_bg_color_type ) {
				$gat_bg_color = gat_get_scheme_color( 'bg_color', $gat_scheme );
			} else {
				$gat_bg_color = '';
			}
			if ( ! empty( $gat_bg_color ) && $gat_bg_mask > 0 ) {
				$gat_css .= 'background-color: ' . esc_attr(
					1 == $gat_bg_mask ? $gat_bg_color : gat_hex2rgba( $gat_bg_color, $gat_bg_mask )
				) . ';';
			}
			if ( ! empty( $gat_css ) ) {
				echo ' style="' . esc_attr( $gat_css ) . '"';
			}
			?>
	>
		<div class="front_page_section_content_wrap front_page_section_about_content_wrap content_wrap">
			<?php
			// Caption
			$gat_caption = gat_get_theme_option( 'front_page_about_caption' );
			if ( ! empty( $gat_caption ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<h2 class="front_page_section_caption front_page_section_about_caption front_page_block_<?php echo ! empty( $gat_caption ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( $gat_caption, 'gat_kses_content' ); ?></h2>
				<?php
			}

			// Description (text)
			$gat_description = gat_get_theme_option( 'front_page_about_description' );
			if ( ! empty( $gat_description ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_description front_page_section_about_description front_page_block_<?php echo ! empty( $gat_description ) ? 'filled' : 'empty'; ?>"><?php echo wp_kses( wpautop( $gat_description ), 'gat_kses_content' ); ?></div>
				<?php
			}

			// Content
			$gat_content = gat_get_theme_option( 'front_page_about_content' );
			if ( ! empty( $gat_content ) || ( current_user_can( 'edit_theme_options' ) && is_customize_preview() ) ) {
				?>
				<div class="front_page_section_content front_page_section_about_content front_page_block_<?php echo ! empty( $gat_content ) ? 'filled' : 'empty'; ?>">
					<?php
					$gat_page_content_mask = '%%CONTENT%%';
					if ( strpos( $gat_content, $gat_page_content_mask ) !== false ) {
						$gat_content = preg_replace(
							'/(\<p\>\s*)?' . $gat_page_content_mask . '(\s*\<\/p\>)/i',
							sprintf(
								'<div class="front_page_section_about_source">%s</div>',
								apply_filters( 'the_content', get_the_content() )
							),
							$gat_content
						);
					}
					gat_show_layout( $gat_content );
					?>
				</div>
				<?php
			}
			?>
		</div>
	</div>
</div>
