<?php
/**
 * The template to display Admin notices
 *
 * @package GAT
 * @since GAT 1.0.64
 */

$gat_skins_url  = get_admin_url( null, 'admin.php?page=trx_addons_theme_panel#trx_addons_theme_panel_section_skins' );
$gat_skins_args = get_query_var( 'gat_skins_notice_args' );
?>
<div class="gat_admin_notice gat_skins_notice notice notice-info is-dismissible" data-notice="skins">
	<?php
	// Theme image
	$gat_theme_img = gat_get_file_url( 'screenshot.jpg' );
	if ( '' != $gat_theme_img ) {
		?>
		<div class="gat_notice_image"><img src="<?php echo esc_url( $gat_theme_img ); ?>" alt="<?php esc_attr_e( 'Theme screenshot', 'gat' ); ?>"></div>
		<?php
	}

	// Title
	?>
	<h3 class="gat_notice_title">
		<?php esc_html_e( 'New skins available', 'gat' ); ?>
	</h3>
	<?php

	// Description
	$gat_total      = $gat_skins_args['update'];	// Store value to the separate variable to avoid warnings from ThemeCheck plugin!
	$gat_skins_msg  = $gat_total > 0
							// Translators: Add new skins number
							? '<strong>' . sprintf( _n( '%d new version', '%d new versions', $gat_total, 'gat' ), $gat_total ) . '</strong>'
							: '';
	$gat_total      = $gat_skins_args['free'];
	$gat_skins_msg .= $gat_total > 0
							? ( ! empty( $gat_skins_msg ) ? ' ' . esc_html__( 'and', 'gat' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d free skin', '%d free skins', $gat_total, 'gat' ), $gat_total ) . '</strong>'
							: '';
	$gat_total      = $gat_skins_args['pay'];
	$gat_skins_msg .= $gat_skins_args['pay'] > 0
							? ( ! empty( $gat_skins_msg ) ? ' ' . esc_html__( 'and', 'gat' ) . ' ' : '' )
								// Translators: Add new skins number
								. '<strong>' . sprintf( _n( '%d paid skin', '%d paid skins', $gat_total, 'gat' ), $gat_total ) . '</strong>'
							: '';
	?>
	<div class="gat_notice_text">
		<p>
			<?php
			// Translators: Add new skins info
			echo wp_kses_data( sprintf( __( "We are pleased to announce that %s are available for your theme", 'gat' ), $gat_skins_msg ) );
			?>
		</p>
	</div>
	<?php

	// Buttons
	?>
	<div class="gat_notice_buttons">
		<?php
		// Link to the theme dashboard page
		?>
		<a href="<?php echo esc_url( $gat_skins_url ); ?>" class="button button-primary"><i class="dashicons dashicons-update"></i> 
			<?php
			// Translators: Add theme name
			esc_html_e( 'Go to Skins manager', 'gat' );
			?>
		</a>
	</div>
</div>
