<?php
/**
 * The template to display default site header
 *
 * @package GAT
 * @since GAT 1.0
 */

$gat_header_css   = '';
$gat_header_image = get_header_image();
$gat_header_video = gat_get_header_video();
if ( ! empty( $gat_header_image ) && gat_trx_addons_featured_image_override( is_singular() || gat_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$gat_header_image = gat_get_current_mode_image( $gat_header_image );
}

?><header class="top_panel top_panel_default
	<?php
	echo ! empty( $gat_header_image ) || ! empty( $gat_header_video ) ? ' with_bg_image' : ' without_bg_image';
	if ( '' != $gat_header_video ) {
		echo ' with_bg_video';
	}
	if ( '' != $gat_header_image ) {
		echo ' ' . esc_attr( gat_add_inline_css_class( 'background-image: url(' . esc_url( $gat_header_image ) . ');' ) );
	}
	if ( is_single() && has_post_thumbnail() ) {
		echo ' with_featured_image';
	}
	if ( gat_is_on( gat_get_theme_option( 'header_fullheight' ) ) ) {
		echo ' header_fullheight gat-full-height';
	}
	$gat_header_scheme = gat_get_theme_option( 'header_scheme' );
	if ( ! empty( $gat_header_scheme ) && ! gat_is_inherit( $gat_header_scheme  ) ) {
		echo ' scheme_' . esc_attr( $gat_header_scheme );
	}
	?>
">
	<?php

	// Background video
	if ( ! empty( $gat_header_video ) ) {
		get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/header-video' ) );
	}

	// Main menu
	get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/header-navi' ) );

	// Mobile header
	if ( gat_is_on( gat_get_theme_option( 'header_mobile_enabled' ) ) ) {
		get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/header-mobile' ) );
	}

	// Page title and breadcrumbs area
	if ( ! is_single() ) {
		get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/header-title' ) );
	}

	// Header widgets area
	get_template_part( apply_filters( 'gat_filter_get_template_part', 'templates/header-widgets' ) );
	?>
</header>
