<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package GAT
 * @since GAT 1.0
 */

$gat_template_args = get_query_var( 'gat_template_args' );
if ( is_array( $gat_template_args ) ) {
	$gat_columns    = empty( $gat_template_args['columns'] ) ? 2 : max( 1, $gat_template_args['columns'] );
	$gat_blog_style = array( $gat_template_args['type'], $gat_columns );
    $gat_columns_class = gat_get_column_class( 1, $gat_columns, ! empty( $gat_template_args['columns_tablet']) ? $gat_template_args['columns_tablet'] : '', ! empty($gat_template_args['columns_mobile']) ? $gat_template_args['columns_mobile'] : '' );
} else {
	$gat_template_args = array();
	$gat_blog_style = explode( '_', gat_get_theme_option( 'blog_style' ) );
	$gat_columns    = empty( $gat_blog_style[1] ) ? 2 : max( 1, $gat_blog_style[1] );
    $gat_columns_class = gat_get_column_class( 1, $gat_columns );
}

$gat_post_format = get_post_format();
$gat_post_format = empty( $gat_post_format ) ? 'standard' : str_replace( 'post-format-', '', $gat_post_format );

?><div class="
<?php
if ( ! empty( $gat_template_args['slider'] ) ) {
	echo ' slider-slide swiper-slide';
} else {
	echo ( gat_is_blog_style_use_masonry( $gat_blog_style[0] ) ? 'masonry_item masonry_item-1_' . esc_attr( $gat_columns ) : esc_attr( $gat_columns_class ));
}
?>
"><article id="post-<?php the_ID(); ?>" 
	<?php
	post_class(
		'post_item post_item_container post_format_' . esc_attr( $gat_post_format )
		. ' post_layout_portfolio'
		. ' post_layout_portfolio_' . esc_attr( $gat_columns )
		. ( 'portfolio' != $gat_blog_style[0] ? ' ' . esc_attr( $gat_blog_style[0] )  . '_' . esc_attr( $gat_columns ) : '' )
	);
	gat_add_blog_animation( $gat_template_args );
	?>
>
<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$gat_hover   = ! empty( $gat_template_args['hover'] ) && ! gat_is_inherit( $gat_template_args['hover'] )
								? $gat_template_args['hover']
								: gat_get_theme_option( 'image_hover' );

	if ( 'dots' == $gat_hover ) {
		$gat_post_link = empty( $gat_template_args['no_links'] )
								? ( ! empty( $gat_template_args['link'] )
									? $gat_template_args['link']
									: get_permalink()
									)
								: '';
		$gat_target    = ! empty( $gat_post_link ) && false === strpos( $gat_post_link, home_url() )
								? ' target="_blank" rel="nofollow"'
								: '';
	}
	
	// Meta parts
	$gat_components = ! empty( $gat_template_args['meta_parts'] )
							? ( is_array( $gat_template_args['meta_parts'] )
								? $gat_template_args['meta_parts']
								: explode( ',', $gat_template_args['meta_parts'] )
								)
							: gat_array_get_keys_by_value( gat_get_theme_option( 'meta_parts' ) );

	// Featured image
	gat_show_post_featured( apply_filters( 'gat_filter_args_featured',
        array(
			'hover'         => $gat_hover,
			'no_links'      => ! empty( $gat_template_args['no_links'] ),
			'thumb_size'    => ! empty( $gat_template_args['thumb_size'] )
								? $gat_template_args['thumb_size']
								: gat_get_thumb_size(
									gat_is_blog_style_use_masonry( $gat_blog_style[0] )
										? (	strpos( gat_get_theme_option( 'body_style' ), 'full' ) !== false || $gat_columns < 3
											? 'masonry-big'
											: 'masonry'
											)
										: (	strpos( gat_get_theme_option( 'body_style' ), 'full' ) !== false || $gat_columns < 3
											? 'square'
											: 'square'
											)
								),
			'thumb_bg' => gat_is_blog_style_use_masonry( $gat_blog_style[0] ) ? false : true,
			'show_no_image' => true,
			'meta_parts'    => $gat_components,
			'class'         => 'dots' == $gat_hover ? 'hover_with_info' : '',
			'post_info'     => 'dots' == $gat_hover
										? '<div class="post_info"><h5 class="post_title">'
											. ( ! empty( $gat_post_link )
												? '<a href="' . esc_url( $gat_post_link ) . '"' . ( ! empty( $target ) ? $target : '' ) . '>'
												: ''
												)
												. esc_html( get_the_title() ) 
											. ( ! empty( $gat_post_link )
												? '</a>'
												: ''
												)
											. '</h5></div>'
										: '',
            'thumb_ratio'   => 'info' == $gat_hover ?  '100:102' : '',
        ),
        'content-portfolio',
        $gat_template_args
    ) );
	?>
</article></div><?php
// Need opening PHP-tag above, because <article> is a inline-block element (used as column)!