<?php
/**
 * The Footer: widgets area, logo, footer menu and socials
 *
 * @package GAT
 * @since GAT 1.0
 */

							do_action( 'gat_action_page_content_end_text' );
							
							// Widgets area below the content
							gat_create_widgets_area( 'widgets_below_content' );
						
							do_action( 'gat_action_page_content_end' );
							?>
						</div>
						<?php
						
						do_action( 'gat_action_after_page_content' );

						// Show main sidebar
						get_sidebar();

						do_action( 'gat_action_content_wrap_end' );
						?>
					</div>
					<?php

					do_action( 'gat_action_after_content_wrap' );

					// Widgets area below the page and related posts below the page
					$gat_body_style = gat_get_theme_option( 'body_style' );
					$gat_widgets_name = gat_get_theme_option( 'widgets_below_page' );
					$gat_show_widgets = ! gat_is_off( $gat_widgets_name ) && is_active_sidebar( $gat_widgets_name );
					$gat_show_related = gat_is_single() && gat_get_theme_option( 'related_position' ) == 'below_page';
					if ( $gat_show_widgets || $gat_show_related ) {
						if ( 'fullscreen' != $gat_body_style ) {
							?>
							<div class="content_wrap">
							<?php
						}
						// Show related posts before footer
						if ( $gat_show_related ) {
							do_action( 'gat_action_related_posts' );
						}

						// Widgets area below page content
						if ( $gat_show_widgets ) {
							gat_create_widgets_area( 'widgets_below_page' );
						}
						if ( 'fullscreen' != $gat_body_style ) {
							?>
							</div>
							<?php
						}
					}
					do_action( 'gat_action_page_content_wrap_end' );
					?>
			</div>
			<?php
			do_action( 'gat_action_after_page_content_wrap' );

			// Don't display the footer elements while actions 'full_post_loading' and 'prev_post_loading'
			if ( ( ! gat_is_singular( 'post' ) && ! gat_is_singular( 'attachment' ) ) || ! in_array ( gat_get_value_gp( 'action' ), array( 'full_post_loading', 'prev_post_loading' ) ) ) {
				
				// Skip link anchor to fast access to the footer from keyboard
				?>
				<a id="footer_skip_link_anchor" class="gat_skip_link_anchor" href="#"></a>
				<?php

				do_action( 'gat_action_before_footer' );

				// Footer
				$gat_footer_type = gat_get_theme_option( 'footer_type' );
				if ( 'custom' == $gat_footer_type && ! gat_is_layouts_available() ) {
					$gat_footer_type = 'default';
				}
				get_template_part( apply_filters( 'gat_filter_get_template_part', "templates/footer-" . sanitize_file_name( $gat_footer_type ) ) );

				do_action( 'gat_action_after_footer' );

			}
			?>

			<?php do_action( 'gat_action_page_wrap_end' ); ?>

		</div>

		<?php do_action( 'gat_action_after_page_wrap' ); ?>

	</div>

	<?php do_action( 'gat_action_after_body' ); ?>

	<?php wp_footer(); ?>

</body>
</html>